# HSV Samples

## example.hsv

Demonstrates key HSV features:

- **Header** - `hsv␟1.0` version, metadata
- **Multiple records** - Three users, two posts
- **Arrays** - `roles␟admin␝editor` (GS-separated)
- **Nesting** - `profile␟␎bio␟...␞location␟...␏` (SO/SI)
- **Multiple blocks** - Two separate STX...ETX sections
- **Ignored content** - Text between blocks (comments)

### Viewing

Control characters are invisible. To see the structure:

```bash
cat -v samples/example.hsv
```

Or use `hexdump`:

```bash
hexdump -C samples/example.hsv | head -20
```

### Parsing

```python
import hsv

with open('samples/example.hsv') as f:
    doc = hsv.parse(f.read())

print(doc['header'])   # {'hsv': '1.0', 'type': 'users', ...}
print(doc['records'])  # [{...}, {...}, ...]
```
